/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.PosePartMutator;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPose {
    public static final ArmorStandPose ATHENA = new ArmorStandPose("athena").withBodyPose(new Rotations(0.0f, 0.0f, 2.0f)).withHeadPose(new Rotations(-5.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(10.0f, 0.0f, -5.0f)).withLeftLegPose(new Rotations(-3.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-60.0f, 20.0f, -10.0f)).withRightLegPose(new Rotations(3.0f, 3.0f, 3.0f));
    public static final ArmorStandPose BRANDISH = new ArmorStandPose("brandish").withBodyPose(new Rotations(0.0f, 0.0f, -2.0f)).withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(20.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, 50.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f));
    public static final ArmorStandPose CANCAN_A = new ArmorStandPose("cancanA").withBodyPose(new Rotations(0.0f, 22.0f, 0.0f)).withHeadPose(new Rotations(-5.0f, 18.0f, 0.0f)).withLeftArmPose(new Rotations(8.0f, 0.0f, -114.0f)).withLeftLegPose(new Rotations(-111.0f, 55.0f, 0.0f)).withRightArmPose(new Rotations(0.0f, 84.0f, 111.0f)).withRightLegPose(new Rotations(0.0f, 23.0f, -13.0f));
    public static final ArmorStandPose CANCAN_B = new ArmorStandPose("cancanB").withBodyPose(new Rotations(0.0f, -18.0f, 0.0f)).withHeadPose(new Rotations(-10.0f, -20.0f, 0.0f)).withLeftArmPose(new Rotations(0.0f, 0.0f, -112.0f)).withLeftLegPose(new Rotations(0.0f, 0.0f, 13.0f)).withRightArmPose(new Rotations(8.0f, 90.0f, 111.0f)).withRightLegPose(new Rotations(-119.0f, -42.0f, 0.0f));
    public static final ArmorStandPose DEFAULT = new ArmorStandPose("default").withLeftArmPose(new Rotations(-10.0f, 0.0f, -10.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-15.0f, 0.0f, 10.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f));
    public static final ArmorStandPose ENTERTAIN = new ArmorStandPose("entertain").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-110.0f, -35.0f, 0.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, 35.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f));
    public static final ArmorStandPose HERO = new ArmorStandPose("hero").withBodyPose(new Rotations(0.0f, 8.0f, 0.0f)).withHeadPose(new Rotations(-4.0f, 67.0f, 0.0f)).withLeftArmPose(new Rotations(16.0f, 32.0f, -8.0f)).withLeftLegPose(new Rotations(0.0f, -75.0f, -8.0f)).withRightArmPose(new Rotations(-99.0f, 63.0f, 0.0f)).withRightLegPose(new Rotations(4.0f, 63.0f, 8.0f));
    public static final ArmorStandPose HONOR = new ArmorStandPose("honor").withHeadPose(new Rotations(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-110.0f, 35.0f, 0.0f)).withLeftLegPose(new Rotations(5.0f, -3.0f, -3.0f)).withRightArmPose(new Rotations(-110.0f, -35.0f, 0.0f)).withRightLegPose(new Rotations(-5.0f, 3.0f, 3.0f));
    public static final ArmorStandPose RIPOSTE = new ArmorStandPose("riposte").withHeadPose(new Rotations(16.0f, 20.0f, 0.0f)).withLeftArmPose(new Rotations(4.0f, 8.0f, 237.0f)).withLeftLegPose(new Rotations(-14.0f, -18.0f, -16.0f)).withRightArmPose(new Rotations(246.0f, 0.0f, 89.0f)).withRightLegPose(new Rotations(8.0f, 20.0f, 4.0f));
    public static final ArmorStandPose SALUTE = new ArmorStandPose("salute").withLeftArmPose(new Rotations(10.0f, 0.0f, -5.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-70.0f, -40.0f, 0.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f));
    public static final ArmorStandPose SOLEMN = new ArmorStandPose("solemn").withBodyPose(new Rotations(0.0f, 0.0f, 2.0f)).withHeadPose(new Rotations(15.0f, 0.0f, 0.0f)).withLeftArmPose(new Rotations(-30.0f, 15.0f, 15.0f)).withLeftLegPose(new Rotations(-1.0f, 0.0f, -1.0f)).withRightArmPose(new Rotations(-60.0f, -20.0f, -10.0f)).withRightLegPose(new Rotations(1.0f, 0.0f, 1.0f));
    public static final ArmorStandPose ZOMBIE = new ArmorStandPose("zombie").withHeadPose(new Rotations(-10.0f, 0.0f, -5.0f)).withLeftArmPose(new Rotations(-105.0f, 0.0f, 0.0f)).withLeftLegPose(new Rotations(7.0f, 0.0f, 0.0f)).withRightArmPose(new Rotations(-100.0f, 0.0f, 0.0f)).withRightLegPose(new Rotations(-46.0f, 0.0f, 0.0f));
    public static final double DEGREES_SNAP_INTERVAL = 0.125;
    public static final DecimalFormat ROTATION_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final Random RANDOM = new Random();
    @Nullable
    private final String translationId;
    private final Rotations headPose;
    private final Rotations bodyPose;
    private final Rotations leftArmPose;
    private final Rotations rightArmPose;
    private final Rotations leftLegPose;
    private final Rotations rightLegPose;

    private ArmorStandPose(@Nullable String translationId) {
        this(translationId, new Rotations(0.0f, 0.0f, 0.0f), new Rotations(0.0f, 0.0f, 0.0f), new Rotations(0.0f, 0.0f, 0.0f), new Rotations(0.0f, 0.0f, 0.0f), new Rotations(0.0f, 0.0f, 0.0f), new Rotations(0.0f, 0.0f, 0.0f));
    }

    private ArmorStandPose(@Nullable String translationId, Rotations headPose, Rotations bodyPose, Rotations leftArmPose, Rotations rightArmPose, Rotations leftLegPose, Rotations rightLegPose) {
        this.translationId = translationId;
        this.headPose = headPose;
        this.bodyPose = bodyPose;
        this.leftArmPose = leftArmPose;
        this.rightArmPose = rightArmPose;
        this.leftLegPose = leftLegPose;
        this.rightLegPose = rightLegPose;
    }

    public static ArmorStandPose empty() {
        return new ArmorStandPose(null);
    }

    public String toString() {
        if (this.translationId != null) {
            return this.translationId.toUpperCase(Locale.ROOT);
        }
        return super.toString();
    }

    public Component getComponent() {
        return Component.m_237115_((String)("armorstatues.entity.armor_stand.pose." + Objects.requireNonNull(this.translationId, "Trying to get component for transient armor stand pose")));
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    public ArmorStandPose withHeadPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, rotation, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withBodyPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, this.headPose, rotation, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftArmPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, this.headPose, this.bodyPose, rotation, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withRightArmPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, this.headPose, this.bodyPose, this.leftArmPose, rotation, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftLegPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, rotation, this.rightLegPose);
    }

    public ArmorStandPose withRightLegPose(Rotations rotation) {
        return new ArmorStandPose(this.translationId, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, rotation);
    }

    public void applyToEntity(ArmorStand armorStand) {
        armorStand.m_31597_(this.headPose);
        armorStand.m_31616_(this.bodyPose);
        armorStand.m_31623_(this.leftArmPose);
        armorStand.m_31628_(this.rightArmPose);
        armorStand.m_31639_(this.leftLegPose);
        armorStand.m_31651_(this.rightLegPose);
    }

    public void serializeAllPoses(CompoundTag tag) {
        this.serializeBodyPoses(tag, null);
        this.serializeArmPoses(tag, null);
        this.serializeLegPoses(tag, null);
    }

    public boolean serializeBodyPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        if (lastSentPose == null || !this.headPose.equals((Object)lastSentPose.headPose) || !this.bodyPose.equals((Object)lastSentPose.bodyPose)) {
            tag.m_128365_("Head", (Tag)this.headPose.m_123155_());
            tag.m_128365_("Body", (Tag)this.bodyPose.m_123155_());
            return true;
        }
        return false;
    }

    public boolean serializeArmPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        if (lastSentPose == null || !this.leftArmPose.equals((Object)lastSentPose.leftArmPose) || !this.rightArmPose.equals((Object)lastSentPose.rightArmPose)) {
            tag.m_128365_("LeftArm", (Tag)this.leftArmPose.m_123155_());
            tag.m_128365_("RightArm", (Tag)this.rightArmPose.m_123155_());
            return true;
        }
        return false;
    }

    public boolean serializeLegPoses(CompoundTag tag, @Nullable ArmorStandPose lastSentPose) {
        if (lastSentPose == null || !this.leftLegPose.equals((Object)lastSentPose.leftLegPose) || !this.rightLegPose.equals((Object)lastSentPose.rightLegPose)) {
            tag.m_128365_("LeftLeg", (Tag)this.leftLegPose.m_123155_());
            tag.m_128365_("RightLeg", (Tag)this.rightLegPose.m_123155_());
            return true;
        }
        return false;
    }

    public static ArmorStandPose fromEntity(ArmorStand armorStand) {
        return new ArmorStandPose(null, armorStand.m_31680_(), armorStand.m_31685_(), armorStand.m_31688_(), armorStand.m_31689_(), armorStand.m_31691_(), armorStand.m_31694_());
    }

    public static void applyTagToEntity(ArmorStand armorStand, CompoundTag tag) {
        ((ArmorStandAccessor)armorStand).callReadPose(tag);
    }

    public static ArmorStandPose random(PosePartMutator[] mutators, boolean clampRotations) {
        ArmorStandPose.checkMutatorsSize(mutators);
        return new ArmorStandPose(null, mutators[0].randomRotations(clampRotations), mutators[1].randomRotations(clampRotations), mutators[2].randomRotations(clampRotations), mutators[3].randomRotations(clampRotations), mutators[4].randomRotations(clampRotations), mutators[5].randomRotations(clampRotations));
    }

    public static ArmorStandPose[] values() {
        return new ArmorStandPose[]{DEFAULT, SOLEMN, ATHENA, BRANDISH, HONOR, ENTERTAIN, SALUTE, HERO, RIPOSTE, ZOMBIE, CANCAN_A, CANCAN_B};
    }

    public static ArmorStandPose selectRandomPose() {
        ArmorStandPose[] values = ArmorStandPose.values();
        return values[RANDOM.nextInt(ArmorStandPose.values().length)];
    }

    public static void checkMutatorsSize(PosePartMutator[] mutators) {
        if (mutators.length != 6) {
            throw new IllegalArgumentException("Invalid mutators size: Expected 6, was %s".formatted(mutators.length));
        }
    }

    public static double snapValue(double value, double snapInterval) {
        if (snapInterval > 0.0 && snapInterval < 1.0) {
            for (double currentSnap = 0.0; currentSnap < 1.0; currentSnap += snapInterval) {
                double snapRegion = snapInterval * 0.1;
                if (!(value >= currentSnap - snapRegion) || !(value < currentSnap + snapRegion)) continue;
                return currentSnap;
            }
        }
        return value;
    }
}

